/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.VoxelBresenhamIterator;
import twilightforest.world.registration.TwilightFeatures;

public class TreeRootsDecorator
extends class_4662 {
    private static final class_4656 EMPTY = class_4651.method_38433((class_2680)class_2246.field_10124.method_9564());
    public static final Codec<TreeRootsDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)16).fieldOf("base_strand_count").forGetter(o -> o.strands), (App)Codec.intRange((int)0, (int)16).fieldOf("additional_random_strands").forGetter(o -> o.addExtraStrands), (App)Codec.intRange((int)0, (int)32).fieldOf("root_length").forGetter(o -> o.length), (App)class_4651.field_24937.optionalFieldOf("exposed_roots_provider").forGetter(o -> Optional.ofNullable(o.surfaceBlock != EMPTY ? o.surfaceBlock : null)), (App)class_4651.field_24937.fieldOf("ground_roots_provider").forGetter(o -> o.rootBlock)).apply((Applicative)instance, TreeRootsDecorator::new));
    private final int strands;
    private final int addExtraStrands;
    private final int length;
    private final class_4651 surfaceBlock;
    private final class_4651 rootBlock;
    private final boolean hasSurfaceRoots;

    private TreeRootsDecorator(int count, int addExtraStrands, int length, Optional<class_4651> surfaceBlock, class_4651 rootBlock) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.rootBlock = rootBlock;
        this.hasSurfaceRoots = surfaceBlock.isPresent();
        this.surfaceBlock = this.hasSurfaceRoots ? surfaceBlock.get() : EMPTY;
    }

    public TreeRootsDecorator(int count, int addExtraStrands, int length, class_4651 rootBlock) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.rootBlock = rootBlock;
        this.hasSurfaceRoots = false;
        this.surfaceBlock = EMPTY;
    }

    public TreeRootsDecorator(int count, int addExtraStrands, int length, class_4651 surfaceBlock, class_4651 rootBlock) {
        this.strands = count;
        this.addExtraStrands = addExtraStrands;
        this.length = length;
        this.rootBlock = rootBlock;
        this.hasSurfaceRoots = true;
        this.surfaceBlock = surfaceBlock;
    }

    protected class_4663<TreeRootsDecorator> method_28893() {
        return (class_4663)TwilightFeatures.TREE_ROOTS.get();
    }

    public void method_23469(class_3746 worldReader, BiConsumer<class_2338, class_2680> worldPlacer, Random random, List<class_2338> trunkBlocks, List<class_2338> leafBlocks) {
        if (trunkBlocks.isEmpty()) {
            return;
        }
        int numBranches = this.strands + random.nextInt(this.addExtraStrands + 1);
        float offset = random.nextFloat();
        class_2338 startPos = trunkBlocks.get(0);
        if (this.hasSurfaceRoots) {
            for (int i = 0; i < numBranches; ++i) {
                class_2338 dest = FeatureLogic.translate(startPos.method_10087(i + 2), this.length, 0.3 * (double)i + (double)offset, 0.8);
                FeaturePlacers.traceExposedRoot(worldReader, worldPlacer, random, this.surfaceBlock, this.rootBlock, new VoxelBresenhamIterator(startPos.method_10074(), dest));
            }
        } else {
            for (int i = 0; i < numBranches; ++i) {
                class_2338 dest = FeatureLogic.translate(startPos.method_10087(i + 2), this.length, 0.3 * (double)i + (double)offset, 0.8);
                FeaturePlacers.traceRoot(worldReader, worldPlacer, random, this.rootBlock, new VoxelBresenhamIterator(startPos.method_10074(), dest));
            }
        }
    }
}

